#version 430

layout (location = 0) in smooth vec3 fragViewPos;
layout (location = 1) in smooth vec3 fragNormal;
layout (location = 2) in vec2 fragTexCoords;
layout (location = 3) in vec4 fragPosLightSpace;
layout (location = 4) flat in int OutInstanceID;
layout (location = 5) flat in int boneID;
layout (location = 6) flat in int OutLocation;
layout (location = 7) in float colorTint;
layout (location = 8) in float lightBrightness;

layout (location = 0) out vec4 gAlbedoSpec;
layout (location = 1) out vec4 gViewPosition; //last one is also depth
layout (location = 2) out vec3 gNormal;
layout (location = 3) out vec4 gShadowVisibility;
layout (location = 4) out vec2 gInstanceID;
layout (location = 5) out vec4 gPhysical;

uniform mat4 view;

uniform vec3 lightDir;

float linearize_depth(float d,float zNear,float zFar)
{
    float z_n = 2.0 * d - 1.0;
    return 2.0 * zNear * zFar / (zFar + zNear - z_n * (zFar - zNear));
}


float randomFloat(float seed){
    return abs(fract(sin(seed)*100000.0)) ;
}

layout(binding = 2, rgba16f) uniform readonly restrict image2D planetTex;

vec3 crystalColors[10] = {vec3(1.0, 0.0, 0.0), vec3(0.0, 1.0, 0.0), vec3(0.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0), vec3(0.5), vec3(0.2, 0.6, 0.3), vec3(0.8, 0.5, 0.1), vec3(0.0, 0.7, 0.8), vec3(0.9, 0.4, 0.4), vec3(0.9, 0.0, 1.0)};

uniform int modelID;

uniform int PLANET1;

uniform int CACTUS1;
uniform int CACTUS2;
uniform int CRYSTAL1;
uniform int CRYSTAL2;
uniform int ICE1;
uniform int ICE2;
uniform int ICE3;
uniform int ICE4;
uniform int METAL1;
uniform int METAL2;
uniform int METAL3;
uniform int ROCK1;
uniform int ROCK2;
uniform int ROCK3;
uniform int TREE1;
uniform int TREE2;
uniform int TREE3;
uniform int SILICON_DEPOSIT;
uniform int HYDROGEN_DEPOSIT;

void main(){
  
	vec3 color = vec3(0.0, 0.0, 0.0);
	vec4 physical = vec4(0.0, 0.0, 0.0, 0.0);

	if(modelID == TREE1){

		vec3 trunkColor = imageLoad(planetTex, ivec2(0, OutLocation)).xyz;
		vec3 leafColor = imageLoad(planetTex, ivec2(1, OutLocation)).xyz;

		if(boneID == 5){ //pine cone
			color = trunkColor;
		}else{
			color =	leafColor;
		}

		color *= colorTint;
		physical = vec4(0.9, 0.0, 0.0, 0.0);
	}	
	if(modelID == TREE2){

		vec3 trunkColor = imageLoad(planetTex, ivec2(0, OutLocation)).xyz;
		vec3 leafColor = imageLoad(planetTex, ivec2(1, OutLocation)).xyz;

		if(boneID == 1){ //flimsy tree
			color = trunkColor;
		}else{
			color =	leafColor;
		}

		color *= colorTint;
		physical = vec4(0.9, 0.0, 0.0, 0.0);
	}	
	if(modelID == TREE3){

		vec3 trunkColor = imageLoad(planetTex, ivec2(0, OutLocation)).xyz;
		vec3 leafColor = imageLoad(planetTex, ivec2(1, OutLocation)).xyz;

		if(boneID == 5){
			color = trunkColor;
		}else{
			color =	leafColor;
		}

		color *= colorTint;
		physical = vec4(0.9, 0.0, 0.0, 0.0);
	}	
	if(modelID == ROCK1 || modelID == ROCK2 || modelID == ROCK3){
		color = vec4(imageLoad(planetTex, ivec2(boneID, OutLocation))).xyz * 1.2;
	}

	if(modelID == CACTUS1 || modelID == CACTUS2 ){
		color = vec4(imageLoad(planetTex, ivec2(boneID, OutLocation))).xyz * 1.1;
		physical = vec4(0.9, 0.0, 0.0, 0.0);
	}

	if(modelID == CRYSTAL1 || modelID == CRYSTAL2 ){
		
		//int randomColor = int(floor(randomFloat(OutInstanceID + float(10 * boneID)) * 10.0));

		//color = crystalColors[randomColor];

		color = vec3(218.0, 165.0, 32.0) / 255.0f;

		//color = vec4(imageLoad(planetTex, ivec2(0, OutLocation))).xyz;

		physical.r = 0.2;

	}	
	if(modelID == SILICON_DEPOSIT){

		color = vec3(1.0, 1.0, 0.4);
		physical.r = 0.2;
		physical.z = 1.5 * lightBrightness;

	}
	if(modelID == HYDROGEN_DEPOSIT){

		color = vec3(0.0, 1.0, 1.0);
		physical.r = 0.2;
		physical.z = 1.5 * lightBrightness;

	}



	gShadowVisibility.xyz = (fragPosLightSpace.xyz / fragPosLightSpace.w) * 0.5 + 0.5;
	
	gAlbedoSpec.xyz = color;
	gPhysical = physical;

	gViewPosition.xyz = fragViewPos.xyz;

	gViewPosition.w = linearize_depth(gl_FragCoord.z, 1.0, 6000);

	gNormal = normalize(fragNormal.xyz);
	gInstanceID = ivec2(modelID, OutInstanceID);
	
}